/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.junit.DockerMatchers;
import java.util.HashMap;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

@NotThreadSafe
public class CreateNetworkCmdIT
extends CmdIT {
    @Test
    public void createNetwork() throws DockerException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        String networkName = "createNetwork";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        MatcherAssert.assertThat((Object)network.getName(), (Matcher)CoreMatchers.is((Object)networkName));
        MatcherAssert.assertThat((Object)network.getDriver(), (Matcher)CoreMatchers.is((Object)"bridge"));
    }

    @Test
    public void createNetworkWithIpamConfig() throws DockerException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        String networkName = "networkIpam";
        String subnet = "10.67.79.0/24";
        Network.Ipam ipam = new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet(subnet)});
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withIpam(ipam).exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        Assert.assertEquals((Object)network.getName(), (Object)networkName);
        Assert.assertEquals((Object)"bridge", (Object)network.getDriver());
        Assert.assertEquals((Object)subnet, (Object)((Network.Ipam.Config)network.getIpam().getConfig().iterator().next()).getSubnet());
    }

    @Test
    public void createAttachableNetwork() throws DockerException {
        Assume.assumeThat((String)"API version should be > 1.24", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_25));
        String networkName = "createAttachableNetwork";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withAttachable(Boolean.valueOf(true)).exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        MatcherAssert.assertThat((Object)network, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((boolean)network.isAttachable());
    }

    @Test
    public void createNetworkWithLabel() throws DockerException {
        DockerAssume.assumeNotSwarm("no network in swarm?", this.dockerRule);
        Assume.assumeThat((String)"API version should be >= 1.21", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_21));
        String networkName = "createNetworkWithLabel";
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("com.example.usage", "test");
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withLabels(labels).exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        Network network = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        Assert.assertEquals((Object)network.getLabels(), labels);
    }
}

