/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CreateVolumeCmdIT
extends CmdIT {
    @Test
    public void createVolume() throws DockerException {
        String volumeName = "volume1";
        CreateVolumeResponse createVolumeResponse = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().withName(volumeName).withDriver("local").withLabels(Collections.singletonMap("is-timelord", "yes")).exec();
        MatcherAssert.assertThat((Object)createVolumeResponse.getName(), (Matcher)Matchers.equalTo((Object)volumeName));
        MatcherAssert.assertThat((Object)createVolumeResponse.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)createVolumeResponse.getLabels(), (Matcher)Matchers.equalTo(Collections.singletonMap("is-timelord", "yes")));
        MatcherAssert.assertThat((Object)createVolumeResponse.getMountpoint(), (Matcher)Matchers.containsString((String)"/volume1/"));
    }

    @Test
    public void createVolumeWithExistingName() throws DockerException {
        String volumeName = "volume1";
        CreateVolumeResponse createVolumeResponse1 = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().withName(volumeName).withDriver("local").withLabels(Collections.singletonMap("is-timelord", "yes")).exec();
        MatcherAssert.assertThat((Object)createVolumeResponse1.getName(), (Matcher)Matchers.equalTo((Object)volumeName));
        MatcherAssert.assertThat((Object)createVolumeResponse1.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)createVolumeResponse1.getLabels(), (Matcher)Matchers.equalTo(Collections.singletonMap("is-timelord", "yes")));
        MatcherAssert.assertThat((Object)createVolumeResponse1.getMountpoint(), (Matcher)Matchers.containsString((String)"/volume1/"));
        CreateVolumeResponse createVolumeResponse2 = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().withName(volumeName).withDriver("local").withLabels(Collections.singletonMap("is-timelord", "yes")).exec();
        MatcherAssert.assertThat((Object)createVolumeResponse2.getName(), (Matcher)Matchers.equalTo((Object)volumeName));
        MatcherAssert.assertThat((Object)createVolumeResponse2.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)createVolumeResponse2.getLabels(), (Matcher)Matchers.equalTo(Collections.singletonMap("is-timelord", "yes")));
        MatcherAssert.assertThat((Object)createVolumeResponse2.getMountpoint(), (Matcher)Matchers.equalTo((Object)createVolumeResponse1.getMountpoint()));
    }
}

