/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import org.junit.Assert;
import org.junit.Test;

public class DisconnectFromNetworkCmdIT
extends CmdIT {
    @Test
    public void disconnectFromNetwork() throws InterruptedException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName("disconnectNetwork").exec();
        this.dockerRule.getClient().connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        Network updatedNetwork = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Assert.assertTrue((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
        this.dockerRule.getClient().disconnectFromNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        updatedNetwork = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Assert.assertFalse((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
    }

    @Test
    public void forceDisconnectFromNetwork() throws InterruptedException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName("testNetwork2").exec();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withHostConfig(HostConfig.newHostConfig().withNetworkMode("testNetwork2")).withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().disconnectFromNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).withForce(Boolean.valueOf(true)).exec();
        Network updatedNetwork = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Assert.assertFalse((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
    }
}

