/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.EventType;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.utils.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(EventsCmdIT.class);

    private static String getEpochTime() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    @Test
    public void testEventStreamTimeBound() throws Exception {
        DockerAssume.assumeNotSwarm("", this.dockerRule);
        String startTime = EventsCmdIT.getEpochTime();
        int expectedEvents = this.generateEvents();
        String endTime = EventsCmdIT.getEpochTime();
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerRule.getClient().eventsCmd().withSince(startTime).withUntil(endTime).exec((ResultCallback)eventCallback);
        List<Event> events = eventCallback.awaitExpectedEvents(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("Received events: " + events), (events.size() >= expectedEvents ? 1 : 0) != 0);
    }

    @Test
    public void testEventStreaming() throws Exception {
        String startTime = EventsCmdIT.getEpochTime();
        int expectedEvents = this.generateEvents();
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerRule.getClient().eventsCmd().withSince(startTime).exec((ResultCallback)eventCallback);
        this.generateEvents();
        List<Event> events = eventCallback.awaitExpectedEvents(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("Received events: " + events), (events.size() >= expectedEvents ? 1 : 0) != 0);
        for (Event event : events) {
            if (TestUtils.isSwarm(this.dockerRule.getClient())) {
                MatcherAssert.assertThat((Object)event.getNode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)event.getNode().getAddr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)event.getNode().getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)event.getNode().getIp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                MatcherAssert.assertThat((Object)event.getNode().getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)event.getNode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void testEventStreamingWithFilter() throws Exception {
        DockerAssume.assumeNotSwarm("", this.dockerRule);
        String startTime = EventsCmdIT.getEpochTime();
        int expectedEvents = 1;
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerRule.getClient().eventsCmd().withSince(startTime).withEventFilter(new String[]{"start"}).exec((ResultCallback)eventCallback);
        this.generateEvents();
        List<Event> events = eventCallback.awaitExpectedEvents(30L, TimeUnit.SECONDS);
        for (Event event : events) {
            MatcherAssert.assertThat((String)("Received event: " + event), (Object)event.getAction(), (Matcher)CoreMatchers.is((Object)"start"));
        }
    }

    @Test
    public void testEventStreamingWithEventTypeFilter() throws Exception {
        DockerAssume.assumeNotSwarm("", this.dockerRule);
        String startTime = EventsCmdIT.getEpochTime();
        this.generateEvents();
        String endTime = EventsCmdIT.getEpochTime();
        for (EventType eventType : EventType.values()) {
            final CopyOnWriteArrayList events = new CopyOnWriteArrayList();
            try (ResultCallback.Adapter eventCallback = (ResultCallback.Adapter)this.dockerRule.getClient().eventsCmd().withSince(startTime).withUntil(endTime).withEventTypeFilter(new EventType[]{eventType}).exec((ResultCallback)new ResultCallback.Adapter<Event>(){

                public void onNext(Event event) {
                    events.add(event);
                }
            });){
                eventCallback.awaitCompletion(30L, TimeUnit.SECONDS);
                for (Event event : events) {
                    MatcherAssert.assertThat((String)("Received event: " + event), (Object)event.getType(), (Matcher)CoreMatchers.is((Object)eventType));
                }
            }
        }
    }

    private int generateEvents() throws Exception {
        String testImage = "busybox:latest";
        this.dockerRule.getClient().pullImageCmd(testImage).start().awaitCompletion();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd(testImage).withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().stopContainerCmd(container.getId()).withTimeout(Integer.valueOf(1)).exec();
        return 5;
    }

    private class EventsTestCallback
    extends ResultCallback.Adapter<Event> {
        private final CountDownLatch countDownLatch;
        private final List<Event> events = new ArrayList<Event>();

        public EventsTestCallback(int expextedEvents) {
            this.countDownLatch = new CountDownLatch(expextedEvents);
        }

        public void onNext(Event event) {
            LOG.info("Received event #{}: {}", (Object)this.countDownLatch.getCount(), (Object)event);
            this.events.add(event);
            this.countDownLatch.countDown();
        }

        public List<Event> awaitExpectedEvents(long timeout, TimeUnit unit) {
            try {
                this.countDownLatch.await(timeout, unit);
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new ArrayList<Event>(this.events);
        }
    }
}

