/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.cmd.CmdIT;
import java.security.SecureRandom;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecCreateCmdImplIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(ExecCreateCmdImplIT.class);

    @Test
    public void execCreateTest() {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withUser("root").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withCmd(new String[]{"touch", "file.log"}).exec();
        MatcherAssert.assertThat((Object)execCreateCmdResponse.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
    }
}

