/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.utils.TestUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecStartCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(ExecStartCmdIT.class);

    @Test
    public void execStart() throws Exception {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).withUser("root").exec();
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        String responseAsString = TestUtils.asString(response);
        Assert.assertNotNull((Object)responseAsString);
        Assert.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void execStartAttached() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).exec();
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        String responseAsString = TestUtils.asString(response);
        Assert.assertNotNull((Object)responseAsString);
        Assert.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=NotFoundException.class)
    public void execStartWithNonExistentUser() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).withUser("NonExistentUser").exec();
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
    }
}

