/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(InfoCmdIT.class);

    @Test
    public void infoTest() throws DockerException {
        DockerClient dockerClient = this.dockerRule.getClient();
        if (((List)dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()).size() == 0) {
            CreateContainerResponse container = dockerClient.createContainerCmd("busybox:latest").withName("docker-java-itest-info").withCmd(new String[]{"touch", "/test"}).exec();
            LOG.info("Created container: {}", (Object)container);
            MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
            dockerClient.startContainerCmd(container.getId()).exec();
        }
        Info dockerInfo = (Info)dockerClient.infoCmd().exec();
        LOG.info(dockerInfo.toString());
        MatcherAssert.assertThat((Object)dockerInfo.getContainers(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dockerInfo.getContainers(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)dockerInfo.getImages(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dockerInfo.getImages(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)dockerInfo.getDebug(), (Matcher)Matchers.notNullValue());
        if (TestUtils.isNotSwarm(dockerClient)) {
            MatcherAssert.assertThat((Object)dockerInfo.getNFd(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((Object)dockerInfo.getNGoroutines(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((Object)dockerInfo.getNCPU(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }
}

