/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.TestUtils;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(InspectContainerCmdIT.class);

    @Test
    public void inspectContainer() throws DockerException {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse containerInfo = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        Assert.assertEquals((Object)containerInfo.getId(), (Object)container.getId());
    }

    @Test
    public void inspectContainerNodeProperty() throws DockerException {
        Map<String, String> label = Collections.singletonMap("inspectContainerNodeProperty", UUID.randomUUID().toString());
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withLabels(label).exec();
        Container containerResult = (Container)((List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(label).exec()).get(0);
        String name = containerResult.getNames()[0];
        InspectContainerResponse containerInfo = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        InspectContainerResponse.Node node = containerInfo.getNode();
        if (TestUtils.isSwarm(this.dockerRule.getClient())) {
            MatcherAssert.assertThat((Object)node, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)node.getAddr(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)node.getIp(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)node.getLabels(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat(node.getLabels().get("com.github.dockerjava.test"), (Matcher)Matchers.is((Object)"docker-java"));
            MatcherAssert.assertThat((Object)node.getCpus(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
            MatcherAssert.assertThat((Object)node.getMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0x4000000L))));
            MatcherAssert.assertThat((Object)("/" + node.getName() + containerInfo.getName()), (Matcher)Matchers.is((Object)name));
        } else {
            MatcherAssert.assertThat((Object)node, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void inspectContainerWithSize() throws DockerException {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerCmd command = this.dockerRule.getClient().inspectContainerCmd(container.getId()).withSize(Boolean.valueOf(true));
        Assert.assertTrue((boolean)command.getSize());
        InspectContainerResponse containerInfo = command.exec();
        Assert.assertEquals((Object)containerInfo.getId(), (Object)container.getId());
        if (TestUtils.isNotSwarm(this.dockerRule.getClient())) {
            Assert.assertNotNull((Object)containerInfo.getSizeRootFs());
            Assert.assertTrue((containerInfo.getSizeRootFs() > 0 ? 1 : 0) != 0);
        }
    }

    @Test(expected=NotFoundException.class)
    public void inspectNonExistingContainer() throws DockerException {
        this.dockerRule.getClient().inspectContainerCmd("non-existing").exec();
    }

    @Test
    public void inspectContainerRestartCount() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getRestartCount(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void inspectContainerNetworkSettings() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        Assert.assertFalse((boolean)inspectContainerResponse.getNetworkSettings().getHairpinMode());
    }

    @Test
    public void inspectContainerNanoCPUs() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNanoCPUs(), (Matcher)Matchers.is((Object)0L));
    }
}

