/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import com.github.dockerjava.utils.TestUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectExecCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(InspectExecCmdIT.class);

    @Test
    public void inspectExec() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse checkFileExec1 = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"test", "-e", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)checkFileExec1.toString());
        MatcherAssert.assertThat((Object)checkFileExec1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(checkFileExec1.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse first = this.dockerRule.getClient().inspectExecCmd(checkFileExec1.getId()).exec();
        MatcherAssert.assertThat((Object)first.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)first.getExitCode(), (Matcher)Matchers.is((Object)1));
        ExecCreateCmdResponse touchFileExec = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)touchFileExec.toString());
        MatcherAssert.assertThat((Object)touchFileExec.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(touchFileExec.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse second = this.dockerRule.getClient().inspectExecCmd(touchFileExec.getId()).exec();
        MatcherAssert.assertThat((Object)second.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)second.getExitCode(), (Matcher)Matchers.is((Object)0));
        ExecCreateCmdResponse checkFileExec2 = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"test", "-e", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)checkFileExec2.toString());
        MatcherAssert.assertThat((Object)checkFileExec2.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(checkFileExec2.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse third = this.dockerRule.getClient().inspectExecCmd(checkFileExec2.getId()).exec();
        MatcherAssert.assertThat((Object)third.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)third.getExitCode(), (Matcher)Matchers.is((Object)0));
        InspectContainerResponse containerInfo = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        Assert.assertEquals((Object)containerInfo.getId(), (Object)container.getId());
        JSONTestHelper.testRoundTrip(containerInfo);
    }

    @Test
    public void inspectExecNetworkSettings() throws IOException {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerRule.getClient());
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"/bin/bash"}).exec();
        LOG.info("Created exec {}", (Object)exec.toString());
        MatcherAssert.assertThat((Object)exec.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectExecResponse inspectExecResponse = this.dockerRule.getClient().inspectExecCmd(exec.getId()).exec();
        if (apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22)) {
            MatcherAssert.assertThat((Object)inspectExecResponse.getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)inspectExecResponse.getCanRemove(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)inspectExecResponse.getContainerID(), (Matcher)Matchers.is((Object)container.getId()));
        } else {
            MatcherAssert.assertThat((Object)inspectExecResponse.getExitCode(), (Matcher)Matchers.is((Object)0));
            Assert.assertNotNull(inspectExecResponse.getContainer().getNetworkSettings().getNetworks().get("bridge"));
        }
        MatcherAssert.assertThat((Object)inspectExecResponse.isOpenStdin(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)inspectExecResponse.isOpenStdout(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)inspectExecResponse.isRunning(), (Matcher)Matchers.is((Object)false));
        InspectExecResponse.Container inspectContainer = inspectExecResponse.getContainer();
        if (apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22)) {
            MatcherAssert.assertThat((Object)inspectContainer, (Matcher)Matchers.nullValue());
        } else {
            MatcherAssert.assertThat((Object)inspectContainer, (Matcher)Matchers.notNullValue());
            Assert.assertNotNull(inspectContainer.getNetworkSettings().getNetworks().get("bridge"));
        }
    }
}

