/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.utils.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class InspectNetworkCmdIT
extends CmdIT {
    @Test
    public void inspectNetwork() throws DockerException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        List networks = (List)this.dockerRule.getClient().listNetworksCmd().exec();
        Network expected = TestUtils.findNetwork(networks, "bridge");
        Network network = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(expected.getId()).exec();
        MatcherAssert.assertThat((Object)network.getName(), (Matcher)Matchers.equalTo((Object)expected.getName()));
        MatcherAssert.assertThat((Object)network.getScope(), (Matcher)Matchers.equalTo((Object)expected.getScope()));
        MatcherAssert.assertThat((Object)network.getDriver(), (Matcher)Matchers.equalTo((Object)expected.getDriver()));
        MatcherAssert.assertThat((Object)((Network.Ipam.Config)network.getIpam().getConfig().get(0)).getSubnet(), (Matcher)Matchers.equalTo((Object)((Network.Ipam.Config)expected.getIpam().getConfig().get(0)).getSubnet()));
        MatcherAssert.assertThat((Object)network.getIpam().getDriver(), (Matcher)Matchers.equalTo((Object)expected.getIpam().getDriver()));
    }
}

