/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.InspectVolumeResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class InspectVolumeCmdIT
extends CmdIT {
    @Test
    public void inspectVolume() throws DockerException {
        String volumeName = "volume1";
        this.dockerRule.getClient().createVolumeCmd().withName(volumeName).withDriver("local").withLabels(Collections.singletonMap("is-timelord", "yes")).exec();
        InspectVolumeResponse inspectVolumeResponse = (InspectVolumeResponse)this.dockerRule.getClient().inspectVolumeCmd(volumeName).exec();
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getName(), (Matcher)Matchers.equalTo((Object)"volume1"));
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getLabels(), (Matcher)Matchers.equalTo(Collections.singletonMap("is-timelord", "yes")));
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getMountpoint(), (Matcher)Matchers.containsString((String)"/volume1/"));
    }

    @Test(expected=NotFoundException.class)
    public void inspectNonExistentVolume() throws DockerException {
        String volumeName = "non-existing";
        this.dockerRule.getClient().inspectVolumeCmd(volumeName).exec();
    }
}

