/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import ch.lambdaj.Lambda;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.PersistenceMatchers;

public class ListContainersCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(ListContainersCmdIT.class);
    private static final String DEFAULT_IMAGE = "busybox";
    private Map<String, String> testLabel;

    @Before
    public void setUp() {
        this.testLabel = Collections.singletonMap("test", UUID.randomUUID().toString());
    }

    @After
    public void tearDown() {
        List containers = (List)this.dockerRule.getClient().listContainersCmd().withLabelFilter(this.testLabel).withShowAll(Boolean.valueOf(true)).exec();
        for (Container container : containers) {
            this.removeContainer(container.getId());
        }
    }

    @Test
    public void testListContainers() throws Exception {
        List containers = (List)this.dockerRule.getClient().listContainersCmd().withLabelFilter(this.testLabel).withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.notNullValue());
        LOG.info("Container List: {}", (Object)containers);
        int size = containers.size();
        CreateContainerResponse container1 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withCmd(new String[]{"echo"}).exec();
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getImage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)DEFAULT_IMAGE)));
        this.dockerRule.getClient().startContainerCmd(container1.getId()).exec();
        LOG.info("container id: " + container1.getId());
        List containers2 = (List)this.dockerRule.getClient().listContainersCmd().withLabelFilter(this.testLabel).withShowAll(Boolean.valueOf(true)).exec();
        for (Container container : containers2) {
            LOG.info("listContainer: id=" + container.getId() + " image=" + container.getImage());
        }
        MatcherAssert.assertThat((Object)(size + 1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)containers2.size())));
        Matcher matcher = Matchers.hasItem((Matcher)PersistenceMatchers.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
        List filteredContainers = Lambda.filter((Matcher)PersistenceMatchers.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())), (Iterable)containers2);
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        for (Container container : filteredContainers) {
            LOG.info("filteredContainer: " + container);
        }
        Container container2 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container2.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)container2.getImage(), (Matcher)Matchers.startsWith((String)DEFAULT_IMAGE));
    }

    @Test
    public void testListContainersWithLabelsFilter() throws Exception {
        this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withCmd(new String[]{"echo"}).withLabels(this.testLabel).exec();
        List filteredContainersByMap = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).exec();
        MatcherAssert.assertThat((Object)filteredContainersByMap.size(), (Matcher)Matchers.is((Object)1));
        Container container3 = (Container)filteredContainersByMap.get(0);
        MatcherAssert.assertThat((Object)container3.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)container3.getImage(), (Matcher)Matchers.startsWith((String)DEFAULT_IMAGE));
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(Collections.singletonList("test=" + this.testLabel.get("test"))).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        container3 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container3.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)container3.getImage(), (Matcher)Matchers.startsWith((String)DEFAULT_IMAGE));
        Assert.assertEquals((Object)this.testLabel.get("test"), container3.getLabels().get("test"));
    }

    @Test
    public void testNameFilter() throws Exception {
        String testUUID = this.testLabel.get("test");
        String id1 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withName("nameFilterTest1-" + testUUID).exec().getId();
        String id2 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withName("nameFilterTest2-" + testUUID).exec().getId();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withNameFilter(Arrays.asList("nameFilterTest1-" + testUUID, "nameFilterTest2-" + testUUID)).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.isOneOf((Object[])new String[]{id1, id2}));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(1)).getId(), (Matcher)Matchers.isOneOf((Object[])new String[]{id1, id2}));
    }

    @Test
    public void testIdsFilter() throws Exception {
        String id1 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec().getId();
        String id2 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec().getId();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withIdFilter(Arrays.asList(id1, id2)).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.isOneOf((Object[])new String[]{id1, id2}));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(1)).getId(), (Matcher)Matchers.isOneOf((Object[])new String[]{id1, id2}));
    }

    @Test
    public void testStatusFilter() throws Exception {
        String id1 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withCmd(new String[]{"sh", "-c", "sleep 99999"}).withLabels(this.testLabel).exec().getId();
        String id2 = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withCmd(new String[]{"sh", "-c", "sleep 99999"}).withLabels(this.testLabel).exec().getId();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withStatusFilter(Collections.singletonList("created")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(1)).getId(), (Matcher)Matchers.isOneOf((Object[])new String[]{id1, id2}));
        this.dockerRule.getClient().startContainerCmd(id1).exec();
        filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withStatusFilter(Collections.singletonList("running")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id1));
        this.dockerRule.getClient().pauseContainerCmd(id1).exec();
        filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withStatusFilter(Collections.singletonList("paused")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id1));
        this.dockerRule.getClient().unpauseContainerCmd(id1).exec();
        this.dockerRule.getClient().stopContainerCmd(id1).exec();
        filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withStatusFilter(Collections.singletonList("exited")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id1));
    }

    @Test
    public void testVolumeFilter() throws Exception {
        this.dockerRule.getClient().createVolumeCmd().withName("TestFilterVolume").withDriver("local").exec();
        String id = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withHostConfig(HostConfig.newHostConfig().withBinds(new Bind[]{new Bind("TestFilterVolume", new Volume("/test"))})).exec().getId();
        this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withVolumeFilter(Collections.singletonList("TestFilterVolume")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id));
    }

    @Test
    public void testNetworkFilter() throws Exception {
        this.dockerRule.getClient().createNetworkCmd().withName("TestFilterNetwork").withDriver("bridge").exec();
        String id = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withHostConfig(HostConfig.newHostConfig().withNetworkMode("TestFilterNetwork")).exec().getId();
        this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(this.testLabel).withNetworkFilter(Collections.singletonList("TestFilterNetwork")).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id));
    }

    @Test
    public void testAncestorFilter() throws Exception {
        DockerAssume.assumeNotSwarm(this.dockerRule.getClient());
        this.dockerRule.getClient().pullImageCmd(DEFAULT_IMAGE).withTag("1.24").start().awaitCompletion();
        this.dockerRule.getClient().createContainerCmd("busybox:1.24").withLabels(this.testLabel).exec();
        String imageId = this.dockerRule.getClient().inspectImageCmd(DEFAULT_IMAGE).exec().getId();
        String id = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec().getId();
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withLabelFilter(this.testLabel).withShowAll(Boolean.valueOf(true)).withAncestorFilter(Collections.singletonList(imageId)).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id));
    }

    @Test
    public void testExitedFilter() throws Exception {
        this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).exec();
        String id = this.dockerRule.getClient().createContainerCmd(DEFAULT_IMAGE).withLabels(this.testLabel).withCmd(new String[]{"sh", "-c", "exit 42"}).exec().getId();
        this.dockerRule.getClient().startContainerCmd(id).exec();
        Integer status = this.dockerRule.getClient().waitContainerCmd(id).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)status, (Matcher)Matchers.is((Object)42));
        List filteredContainers = (List)this.dockerRule.getClient().listContainersCmd().withLabelFilter(this.testLabel).withShowAll(Boolean.valueOf(true)).withExitedFilter(Integer.valueOf(42)).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Container)filteredContainers.get(0)).getId(), (Matcher)Matchers.is((Object)id));
    }

    private void removeContainer(String id) {
        if (id != null) {
            try {
                this.dockerRule.getClient().removeContainerCmd(id).withForce(Boolean.valueOf(true)).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

