/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListImagesCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(ListImagesCmdIT.class);

    @Test
    public void listImages() throws DockerException {
        List images = (List)this.dockerRule.getClient().listImagesCmd().withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        Info info = (Info)this.dockerRule.getClient().infoCmd().exec();
        if (TestUtils.isNotSwarm(this.dockerRule.getClient())) {
            MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.equalTo((Object)info.getImages()));
        }
        Image img = (Image)images.get(0);
        MatcherAssert.assertThat((Object)img.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getVirtualSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)img.getRepoTags(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }

    @Test
    public void listImagesWithDanglingFilter() throws DockerException {
        String imageId = this.createDanglingImage();
        List images = (List)this.dockerRule.getClient().listImagesCmd().withDanglingFilter(Boolean.valueOf(true)).withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Boolean imageInFilteredList = this.isImageInFilteredList(images, imageId);
        Assert.assertTrue((boolean)imageInFilteredList);
    }

    private boolean isImageInFilteredList(List<Image> images, String expectedImageId) {
        for (Image image : images) {
            if (!expectedImageId.equals(image.getId())) continue;
            return true;
        }
        return false;
    }

    private String createDanglingImage() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LOG.info("Committing container {}", (Object)container.toString());
        String imageId = this.dockerRule.getClient().commitCmd(container.getId()).exec();
        this.dockerRule.getClient().stopContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().removeContainerCmd(container.getId()).exec();
        return imageId;
    }
}

