/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.utils.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ListNetworksCmdIT
extends CmdIT {
    @Test
    public void listNetworks() throws DockerException {
        DockerAssume.assumeNotSwarm("Swarm has no network", this.dockerRule);
        List networks = (List)this.dockerRule.getClient().listNetworksCmd().exec();
        Network network = TestUtils.findNetwork(networks, "bridge");
        MatcherAssert.assertThat((Object)network.getName(), (Matcher)Matchers.equalTo((Object)"bridge"));
        MatcherAssert.assertThat((Object)network.getScope(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)network.getDriver(), (Matcher)Matchers.equalTo((Object)"bridge"));
        MatcherAssert.assertThat((Object)network.getIpam().getDriver(), (Matcher)Matchers.equalTo((Object)"default"));
    }
}

