/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.TestResources;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@NotThreadSafe
public class LoadImageCmdIT
extends CmdIT {
    private String expectedImageId;

    @Before
    public void beforeMethod() {
        this.expectedImageId = "sha256:56031f66eb0cef2e2e5cb2d1dabafaa0ebcd0a18a507d313b5bdb8c0472c5eba";
        if (this.findImageWithId(this.expectedImageId, (List)this.dockerRule.getClient().listImagesCmd().exec()) != null) {
            this.dockerRule.getClient().removeImageCmd(this.expectedImageId).exec();
        }
    }

    @After
    public void afterMethod() {
        this.dockerRule.getClient().removeImageCmd(this.expectedImageId).exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadImageFromTar() throws Exception {
        try (Object uploadStream = Files.newInputStream(TestResources.getApiImagesLoadTestTarball(), new OpenOption[0]);){
            this.dockerRule.getClient().loadImageCmd((InputStream)uploadStream).exec();
        }
        uploadStream = this;
        synchronized (uploadStream) {
            this.wait(5000L);
        }
        Image image = this.findImageWithId(this.expectedImageId, (List)this.dockerRule.getClient().listImagesCmd().exec());
        MatcherAssert.assertThat((String)"Can't find expected image after loading from a tar archive!", (Object)image, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((String)"Image after loading from a tar archive has wrong tags!", Arrays.asList(image.getRepoTags()), (Matcher)IsEqual.equalTo(Collections.singletonList("docker-java/load:1.0")));
    }

    private Image findImageWithId(String id, List<Image> images) {
        for (Image image : images) {
            if (!id.equals(image.getId())) continue;
            return image;
        }
        return null;
    }
}

