/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.LogContainerTestCallback;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogContainerCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(LogContainerCmdIT.class);

    @Test
    public void asyncLogContainerWithTtyEnabled() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "while true; do echo hello; sleep 1; done"}).withTty(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LogContainerTestCallback loggingCallback = new LogContainerTestCallback(true);
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)loggingCallback.toString().contains("hello"));
        Assert.assertEquals((Object)loggingCallback.getCollectedFrames().get(0).getStreamType(), (Object)StreamType.RAW);
    }

    @Test
    public void asyncLogContainerWithTtyDisabled() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "while true; do echo hello; sleep 1; done"}).withTty(Boolean.valueOf(false)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LogContainerTestCallback loggingCallback = new LogContainerTestCallback(true);
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)loggingCallback.toString().contains("hello"));
        Assert.assertEquals((Object)StreamType.STDOUT, (Object)loggingCallback.getCollectedFrames().get(0).getStreamType());
    }

    @Test
    public void asyncLogNonExistingContainer() throws Exception {
        LogContainerTestCallback loggingCallback = new LogContainerTestCallback(){

            public void onError(Throwable throwable) {
                Assert.assertEquals((Object)NotFoundException.class.getName(), (Object)throwable.getClass().getName());
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
                super.onError(throwable);
            }

            public void onComplete() {
                super.onComplete();
                throw new AssertionError((Object)"expected NotFoundException");
            }
        };
        ((LogContainerTestCallback)this.dockerRule.getClient().logContainerCmd("non-existing").withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback)).awaitCompletion();
    }

    @Test
    public void asyncMultipleLogContainer() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"/bin/echo", snippet}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        LogContainerTestCallback loggingCallback = new LogContainerTestCallback();
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.close();
        loggingCallback = new LogContainerTestCallback();
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.close();
        loggingCallback = new LogContainerTestCallback();
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion();
        Assert.assertTrue((boolean)loggingCallback.toString().contains(snippet));
    }

    @Test
    public void asyncLogContainerWithSince() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"/bin/echo", snippet}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        LogContainerTestCallback loggingCallback = new LogContainerTestCallback();
        this.dockerRule.getClient().logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withSince(Integer.valueOf(timestamp)).withUntil(Integer.valueOf(timestamp + 1000)).exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion();
        MatcherAssert.assertThat((Object)loggingCallback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void simultaneousCommands() throws Exception {
        DockerClient client = this.dockerRule.newClient();
        CreateContainerResponse container = client.createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "echo hello world; sleep infinity"}).exec();
        client.startContainerCmd(container.getId()).exec();
        int connections = 100;
        ExecutorService executor = Executors.newFixedThreadPool(connections);
        try {
            final CopyOnWriteArrayList firstFrames = new CopyOnWriteArrayList();
            executor.invokeAll(LongStream.range(0L, connections).mapToObj(__ -> () -> client.logContainerCmd(container.getId()).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){
                final AtomicBoolean first = new AtomicBoolean(true);

                public void onNext(Frame object) {
                    if (this.first.compareAndSet(true, false)) {
                        firstFrames.add(object);
                    }
                    super.onNext((Object)object);
                }
            })).collect(Collectors.toList()));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> MatcherAssert.assertThat((Object)firstFrames, (Matcher)Matchers.hasSize((int)connections)));
            MatcherAssert.assertThat(firstFrames, (Matcher)CoreMatchers.everyItem((Matcher)Matchers.hasToString((String)"STDOUT: hello world")));
        }
        finally {
            executor.shutdownNow();
        }
    }
}

