/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.ContainerUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PauseCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(PauseCmdIT.class);

    @Test
    public void pauseRunningContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.pauseContainer(this.dockerRule.getClient(), container);
    }

    @Test(expected=NotFoundException.class)
    public void pauseNonExistingContainer() {
        this.dockerRule.getClient().pauseContainerCmd("non-existing").exec();
    }

    @Test(expected=DockerException.class)
    public void pauseStoppedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.stopContainer(this.dockerRule.getClient(), container);
        this.dockerRule.getClient().pauseContainerCmd(container.getId()).exec();
    }

    @Test(expected=DockerException.class)
    public void pausePausedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.pauseContainer(this.dockerRule.getClient(), container);
        this.dockerRule.getClient().pauseContainerCmd(container.getId()).exec();
    }

    @Test(expected=DockerException.class)
    public void pauseCreatedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().pauseContainerCmd(container.getId()).exec();
    }
}

