/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.PrivateRegistryRule;
import com.github.dockerjava.utils.TestUtils;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullImageCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(PullImageCmdIT.class);
    @ClassRule
    public static PrivateRegistryRule REGISTRY = new PrivateRegistryRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testPullImage() throws Exception {
        Info info = (Info)this.dockerRule.getClient().infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        int imgCount = info.getImages();
        LOG.info("imgCount1: {}", (Object)imgCount);
        String testImage = "hackmann/empty";
        LOG.info("Removing image: {}", (Object)testImage);
        try {
            this.dockerRule.getClient().removeImageCmd(testImage).withForce(Boolean.valueOf(true)).exec();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        info = (Info)this.dockerRule.getClient().infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        imgCount = info.getImages();
        LOG.info("imgCount2: {}", (Object)imgCount);
        LOG.info("Pulling image: {}", (Object)testImage);
        this.dockerRule.getClient().pullImageCmd(testImage).start().awaitCompletion(30L, TimeUnit.SECONDS);
        info = (Info)this.dockerRule.getClient().infoCmd().exec();
        LOG.info("Client info after pull, {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)imgCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)info.getImages()));
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(testImage).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testPullNonExistingImage() throws Exception {
        if (TestUtils.isNotSwarm(this.dockerRule.getClient()) && TestUtils.getVersion(this.dockerRule.getClient()).isGreaterOrEqual(RemoteApiVersion.VERSION_1_26)) {
            this.exception.expect(NotFoundException.class);
        } else {
            this.exception.expect(DockerClientException.class);
        }
        this.dockerRule.getClient().pullImageCmd("xvxcv/foo").start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPullImageWithValidAuth() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        String imgName = REGISTRY.createPrivateImage("pull-image-with-valid-auth");
        this.dockerRule.getClient().pullImageCmd(imgName).withAuthConfig(authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPullImageWithValidAuthAndEmail() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig().withEmail("foo@bar.de");
        String imgName = REGISTRY.createPrivateImage("pull-image-with-valid-auth");
        this.dockerRule.getClient().pullImageCmd(imgName).withAuthConfig(authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPullImageWithNoAuth() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        String imgName = REGISTRY.createPrivateImage("pull-image-with-no-auth");
        if (TestUtils.isNotSwarm(this.dockerRule.getClient()) && TestUtils.getVersion(this.dockerRule.getClient()).isGreaterOrEqual(RemoteApiVersion.VERSION_1_30)) {
            this.exception.expect(DockerException.class);
        } else {
            this.exception.expect(DockerClientException.class);
        }
        this.dockerRule.getClient().pullImageCmd(imgName).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPullImageWithInvalidAuth() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        AuthConfig invalidAuthConfig = new AuthConfig().withUsername("testuser").withPassword("testwrongpassword").withEmail("foo@bar.de").withRegistryAddress(authConfig.getRegistryAddress());
        String imgName = REGISTRY.createPrivateImage("pull-image-with-invalid-auth");
        if (TestUtils.isNotSwarm(this.dockerRule.getClient()) && TestUtils.getVersion(this.dockerRule.getClient()).isGreaterOrEqual(RemoteApiVersion.VERSION_1_30)) {
            this.exception.expect(DockerException.class);
        } else {
            this.exception.expect(DockerClientException.class);
        }
        this.dockerRule.getClient().pullImageCmd(imgName).withAuthConfig(invalidAuthConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }
}

