/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.PrivateRegistryRule;
import com.github.dockerjava.utils.TestUtils;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushImageCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(PushImageCmdIT.class);
    @ClassRule
    public static PrivateRegistryRule REGISTRY = new PrivateRegistryRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private AuthConfig authConfig;

    @Before
    public void beforeTest() throws Exception {
        this.authConfig = REGISTRY.getAuthConfig();
    }

    @Test
    public void pushLatest() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        LOG.info("Committing container: {}", (Object)container.toString());
        String imgName = this.authConfig.getRegistryAddress() + "/push-latest";
        String imageId = this.dockerRule.getClient().commitCmd(container.getId()).withRepository(imgName).exec();
        this.dockerRule.getClient().pushImageCmd(imgName).withAuthConfig(this.authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
        LOG.info("Removing image: {}", (Object)imageId);
        this.dockerRule.getClient().removeImageCmd(imageId).exec();
        this.dockerRule.getClient().pullImageCmd(imgName).withTag("latest").withAuthConfig(this.authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void pushNonExistentImage() throws Exception {
        if (TestUtils.isNotSwarm(this.dockerRule.getClient()) && TestUtils.getVersion(this.dockerRule.getClient()).isGreaterOrEqual(RemoteApiVersion.VERSION_1_24)) {
            this.exception.expect(DockerClientException.class);
        } else {
            this.exception.expect(NotFoundException.class);
        }
        this.dockerRule.getClient().pushImageCmd(UUID.randomUUID().toString().replace("-", "")).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPushImageWithValidAuth() throws Exception {
        String imgName = REGISTRY.createTestImage("push-image-with-valid-auth");
        this.dockerRule.getClient().pushImageCmd(imgName).withAuthConfig(this.authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPushImageWithNoAuth() throws Exception {
        String imgName = REGISTRY.createTestImage("push-image-with-no-auth");
        this.exception.expect(DockerClientException.class);
        this.dockerRule.getClient().pushImageCmd(imgName).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testPushImageWithInvalidAuth() throws Exception {
        AuthConfig invalidAuthConfig = new AuthConfig().withUsername("testuser").withPassword("testwrongpassword").withEmail("foo@bar.de").withRegistryAddress(this.authConfig.getRegistryAddress());
        String imgName = REGISTRY.createTestImage("push-image-with-invalid-auth");
        this.exception.expect(DockerClientException.class);
        this.dockerRule.getClient().pushImageCmd(imgName).withAuthConfig(invalidAuthConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
    }
}

