/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class RemoveContainerCmdImplIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveContainerCmdImplIT.class);

    @Test
    public void removeContainer() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        LOG.info("Removing container: {}", (Object)container.getId());
        this.dockerRule.getClient().removeContainerCmd(container.getId()).exec();
        List containers2 = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container.getId()))));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
    }

    @Test(expected=NotFoundException.class)
    public void removeNonExistingContainer() throws DockerException {
        this.dockerRule.getClient().removeContainerCmd("non-existing").exec();
    }
}

