/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class RemoveImageCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveImageCmdIT.class);

    @Test
    public void removeImage() throws DockerException, InterruptedException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LOG.info("Committing container {}", (Object)container.toString());
        String imageId = this.dockerRule.getClient().commitCmd(container.getId()).exec();
        this.dockerRule.getClient().stopContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().removeContainerCmd(container.getId()).exec();
        LOG.info("Removing image: {}", (Object)imageId);
        this.dockerRule.getClient().removeImageCmd(imageId).exec();
        List containers = (List)this.dockerRule.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)imageId))));
        MatcherAssert.assertThat((Object)containers, (Matcher)matcher);
    }

    @Test(expected=NotFoundException.class)
    public void removeNonExistingImage() throws DockerException, InterruptedException {
        this.dockerRule.getClient().removeImageCmd("non-existing").exec();
    }
}

