/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class RemoveNetworkCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveNetworkCmdIT.class);

    @Test
    public void removeNetwork() throws DockerException {
        DockerAssume.assumeNotSwarm("Swarm has no network", this.dockerRule);
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName("test-network").exec();
        LOG.info("Removing network: {}", (Object)network.getId());
        this.dockerRule.getClient().removeNetworkCmd(network.getId()).exec();
        List networks = (List)this.dockerRule.getClient().listNetworksCmd().exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)network.getId()))));
        MatcherAssert.assertThat((Object)networks, (Matcher)matcher);
    }

    @Test(expected=NotFoundException.class)
    public void removeNonExistingContainer() throws DockerException {
        DockerAssume.assumeNotSwarm("Swarm has no network", this.dockerRule);
        this.dockerRule.getClient().removeNetworkCmd("non-existing").exec();
    }
}

