/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RemoveVolumeCmdIT
extends CmdIT {
    @Test(expected=NotFoundException.class)
    public void removeVolume() throws DockerException {
        String volumeName = "volume1";
        CreateVolumeResponse createVolumeResponse = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().withName(volumeName).withDriver("local").withLabels(Collections.singletonMap("is-timelord", "yes")).exec();
        MatcherAssert.assertThat((Object)createVolumeResponse.getName(), (Matcher)Matchers.equalTo((Object)volumeName));
        MatcherAssert.assertThat((Object)createVolumeResponse.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)createVolumeResponse.getLabels(), (Matcher)Matchers.equalTo(Collections.singletonMap("is-timelord", "yes")));
        MatcherAssert.assertThat((Object)createVolumeResponse.getMountpoint(), (Matcher)Matchers.containsString((String)volumeName));
        this.dockerRule.getClient().removeVolumeCmd(volumeName).exec();
        this.dockerRule.getClient().inspectVolumeCmd(volumeName).exec();
    }
}

