/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(RenameContainerCmdIT.class);

    @Test
    public void renameContainer() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        String name1 = inspectContainerResponse.getName();
        this.dockerRule.getClient().renameContainerCmd(container.getId()).withName("renameContainer").exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect After Rename: {}", (Object)inspectContainerResponse2.toString());
        String name2 = inspectContainerResponse2.getName();
        Assert.assertNotEquals((Object)name1, (Object)name2);
        this.dockerRule.getClient().killContainerCmd(container.getId()).exec();
    }

    @Test(expected=NotFoundException.class)
    public void renameExistingContainer() throws DockerException, InterruptedException {
        this.dockerRule.getClient().renameContainerCmd("non-existing").withName("renameExistingContainer").exec();
    }
}

