/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.cmd.CmdIT;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizeContainerCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(ResizeContainerCmdIT.class);
    private static final int TTY_HEIGHT = 30;
    private static final int TTY_WIDTH = 120;

    @Test
    public void resizeContainerTtyTest() {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withUser("root").withCmd(new String[]{"sh", "-c", String.format("until stty size | grep '%d %d'; do : ; done", 30, 120)}).withName(containerName).withTty(Boolean.valueOf(true)).withStdinOpen(Boolean.valueOf(true)).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().resizeContainerCmd(container.getId()).withSize(30, 120).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode(10L, TimeUnit.SECONDS);
        LOG.info("Container exit code: {}", (Object)exitCode);
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
    }
}

