/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizeExecCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(ResizeExecCmdIT.class);
    private static final int TTY_HEIGHT = 30;
    private static final int TTY_WIDTH = 120;

    @Test
    public void resizeExecInstanceTtyTest() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withUser("root").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerRule.getClient().execCreateCmd(container.getId()).withTty(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"sh", "-c", String.format("until stty size | grep '%d %d'; do : ; done", 30, 120)}).exec();
        ExecStartResultCallback execStartResultCallback = new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err);
        ((ExecStartResultCallback)this.dockerRule.getClient().execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)execStartResultCallback)).awaitStarted();
        this.dockerRule.getClient().resizeExecCmd(execCreateCmdResponse.getId()).withSize(30, 120).exec();
        boolean waitResult = execStartResultCallback.awaitCompletion(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)waitResult, (Matcher)Matchers.equalTo((Object)true));
    }
}

