/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartContainerCmdImplIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(RestartContainerCmdImplIT.class);

    @Test
    public void restartContainer() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        String startTime = inspectContainerResponse.getState().getStartedAt();
        this.dockerRule.getClient().restartContainerCmd(container.getId()).withtTimeout(Integer.valueOf(2)).exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect After Restart: {}", (Object)inspectContainerResponse2.toString());
        String startTime2 = inspectContainerResponse2.getState().getStartedAt();
        MatcherAssert.assertThat((Object)startTime, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)startTime2)));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        this.dockerRule.getClient().killContainerCmd(container.getId()).exec();
    }

    @Test(expected=NotFoundException.class)
    public void restartNonExistingContainer() throws DockerException, InterruptedException {
        this.dockerRule.getClient().restartContainerCmd("non-existing").exec();
    }
}

