/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.cmd.CmdIT;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveImagesCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(SaveImagesCmdIT.class);

    @Test
    public void saveNoImages() throws Exception {
        try (InputStream inputStream = this.dockerRule.getClient().saveImagesCmd().exec();
             InputStream image = IOUtils.toBufferedInputStream((InputStream)inputStream);){
            MatcherAssert.assertThat((Object)image.read(), (Matcher)Matchers.not((Object)-1));
        }
    }

    @Test
    public void saveImagesWithNameAndTag() throws Exception {
        try (InputStream inputStream = this.dockerRule.getClient().saveImagesCmd().withImage("busybox", "latest").exec();
             InputStream image = IOUtils.toBufferedInputStream((InputStream)inputStream);){
            MatcherAssert.assertThat((Object)image.read(), (Matcher)Matchers.not((Object)-1));
        }
    }

    @Test
    public void saveMultipleImages() throws Exception {
        try (InputStream inputStream = this.dockerRule.getClient().saveImagesCmd().withImage("busybox", "latest").withImage("busybox", "latest").exec();
             InputStream image = IOUtils.toBufferedInputStream((InputStream)inputStream);){
            MatcherAssert.assertThat((Object)image.read(), (Matcher)Matchers.not((Object)-1));
        }
    }
}

