/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import ch.lambdaj.Lambda;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.cmd.CmdIT;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class SearchImagesCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(SearchImagesCmdIT.class);

    @Test
    public void searchImages() throws DockerException {
        List dockerSearch = (List)this.dockerRule.getClient().searchImagesCmd("busybox").exec();
        LOG.info("Search returned {}", (Object)dockerSearch.toString());
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.equalTo((Object)"busybox")));
        MatcherAssert.assertThat((Object)dockerSearch, (Matcher)matcher);
        MatcherAssert.assertThat((Object)Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.is((Object)"busybox")), (Iterable)dockerSearch).size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void searchImagesWithInvalidMinimumLimit() throws DockerException {
        this.dockerRule.getClient().searchImagesCmd("busybox").withLimit(Integer.valueOf(0)).exec();
    }

    @Test(expected=IllegalArgumentException.class)
    public void searchImagesWithInvalidMaximumLimit() throws DockerException {
        this.dockerRule.getClient().searchImagesCmd("busybox").withLimit(Integer.valueOf(101)).exec();
    }

    @Test
    public void searchImagesWithValidMinimumLimit() throws DockerException {
        List dockerSearch = (List)this.dockerRule.getClient().searchImagesCmd("busybox").withLimit(Integer.valueOf(1)).exec();
        LOG.info("Search returned {}", (Object)dockerSearch.toString());
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.equalTo((Object)"busybox")));
        MatcherAssert.assertThat((Object)dockerSearch, (Matcher)matcher);
        MatcherAssert.assertThat((Object)Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.is((Object)"busybox")), (Iterable)dockerSearch).size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)dockerSearch.size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void searchImagesWithValidMaximumLimit() throws DockerException {
        List dockerSearch = (List)this.dockerRule.getClient().searchImagesCmd("busybox").withLimit(Integer.valueOf(1)).exec();
        LOG.info("Search returned {}", (Object)dockerSearch.toString());
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.equalTo((Object)"busybox")));
        MatcherAssert.assertThat((Object)dockerSearch, (Matcher)matcher);
        MatcherAssert.assertThat((Object)Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.is((Object)"busybox")), (Iterable)dockerSearch).size(), (Matcher)Matchers.equalTo((Object)1));
    }
}

