/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.cmd.CmdIT;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(StatsCmdIT.class);
    private static int NUM_STATS = 3;

    @Test
    public void testStatsStreaming() throws InterruptedException, IOException {
        CountDownLatch countDownLatch = new CountDownLatch(NUM_STATS);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"top"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        boolean gotStats = false;
        try (StatsCallbackTest statsCallback = (StatsCallbackTest)this.dockerRule.getClient().statsCmd(container.getId()).exec((ResultCallback)new StatsCallbackTest(countDownLatch));){
            Assert.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
            gotStats = statsCallback.gotStats();
            LOG.info("Stop stats collection");
        }
        LOG.info("Stopping container");
        this.dockerRule.getClient().stopContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().removeContainerCmd(container.getId()).exec();
        LOG.info("Completed test");
        Assert.assertTrue((String)"Expected true", (boolean)gotStats);
    }

    @Test
    public void testStatsNoStreaming() throws InterruptedException, IOException {
        CountDownLatch countDownLatch = new CountDownLatch(NUM_STATS);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"top"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        try (StatsCallbackTest statsCallback = (StatsCallbackTest)this.dockerRule.getClient().statsCmd(container.getId()).withNoStream(true).exec((ResultCallback)new StatsCallbackTest(countDownLatch));){
            countDownLatch.await(5L, TimeUnit.SECONDS);
            LOG.info("Stop stats collection");
        }
        LOG.info("Stopping container");
        this.dockerRule.getClient().stopContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().removeContainerCmd(container.getId()).exec();
        LOG.info("Completed test");
        Assert.assertEquals((String)"Expected stats called only once", (long)countDownLatch.getCount(), (long)(NUM_STATS - 1));
    }

    private static class StatsCallbackTest
    extends ResultCallbackTemplate<StatsCallbackTest, Statistics> {
        private final CountDownLatch countDownLatch;
        private Boolean gotStats = false;

        public StatsCallbackTest(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onNext(Statistics stats) {
            LOG.info("Received stats #{}: {}", (Object)this.countDownLatch.getCount(), (Object)stats);
            if (stats != null) {
                this.gotStats = true;
            }
            this.countDownLatch.countDown();
        }

        public Boolean gotStats() {
            return this.gotStats;
        }
    }
}

