/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(StopContainerCmdIT.class);

    @Test
    public void testStopContainer() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LOG.info("Stopping container: {}", (Object)container.getId());
        this.dockerRule.getClient().stopContainerCmd(container.getId()).withTimeout(Integer.valueOf(2)).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        Integer exitCode = inspectContainerResponse.getState().getExitCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.is((Object)137));
    }

    @Test(expected=NotFoundException.class)
    public void testStopNonExistingContainer() throws DockerException {
        this.dockerRule.getClient().stopContainerCmd("non-existing").withTimeout(Integer.valueOf(2)).exec();
    }
}

