/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.transport.DockerHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TrackingDockerHttpClient
implements DockerHttpClient {
    static final Set<TrackedResponse> ACTIVE_RESPONSES = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DockerHttpClient delegate;

    TrackingDockerHttpClient(DockerHttpClient delegate) {
        this.delegate = delegate;
    }

    public DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        return new TrackedResponse(this.delegate.execute(request)){
            {
                Set<TrackedResponse> set = ACTIVE_RESPONSES;
                synchronized (set) {
                    ACTIVE_RESPONSES.add(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Set<TrackedResponse> set = ACTIVE_RESPONSES;
                synchronized (set) {
                    ACTIVE_RESPONSES.remove(this);
                }
                super.close();
            }
        };
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    static class TrackedResponse
    implements DockerHttpClient.Response {
        final Exception allocatedAt = new AllocatedAt(this.toString());
        private final DockerHttpClient.Response delegate;

        TrackedResponse(DockerHttpClient.Response delegate) {
            this.delegate = delegate;
        }

        public int getStatusCode() {
            return this.delegate.getStatusCode();
        }

        public Map<String, List<String>> getHeaders() {
            return this.delegate.getHeaders();
        }

        public InputStream getBody() {
            return this.delegate.getBody();
        }

        public void close() {
            this.delegate.close();
        }

        @Nullable
        public String getHeader(@Nonnull String name) {
            return this.delegate.getHeader(name);
        }

        private static class AllocatedAt
        extends Exception {
            public AllocatedAt(String message) {
                super(message);
            }
        }
    }
}

