/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.utils.ContainerUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpauseCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(UnpauseCmdIT.class);

    @Test
    public void unpausePausedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.pauseContainer(this.dockerRule.getClient(), container);
        ContainerUtils.unpauseContainer(this.dockerRule.getClient(), container);
    }

    @Test(expected=InternalServerErrorException.class)
    public void unpauseRunningContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        this.dockerRule.getClient().unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expected=InternalServerErrorException.class)
    public void unpauseStoppedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.stopContainer(this.dockerRule.getClient(), container);
        this.dockerRule.getClient().unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expected=NotFoundException.class)
    public void unpauseNonExistingContainer() {
        this.dockerRule.getClient().unpauseContainerCmd("non-existing").exec();
    }

    @Test(expected=InternalServerErrorException.class)
    public void unpauseCreatedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expected=InternalServerErrorException.class)
    public void unpauseUnpausedContainer() {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        ContainerUtils.startContainer(this.dockerRule.getClient(), container);
        ContainerUtils.pauseContainer(this.dockerRule.getClient(), container);
        this.dockerRule.getClient().unpauseContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().unpauseContainerCmd(container.getId()).exec();
    }
}

