/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.command.UpdateContainerCmdImpl;
import com.github.dockerjava.junit.DockerMatchers;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(UpdateContainerCmdIT.class);

    @Test
    public void updateContainer() throws DockerException, IOException {
        Assume.assumeThat((String)"API version should be >= 1.22", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22));
        CreateContainerResponse response = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).exec();
        String containerId = response.getId();
        this.dockerRule.getClient().startContainerCmd(containerId).exec();
        InspectContainerResponse inspectBefore = this.dockerRule.getClient().inspectContainerCmd(containerId).exec();
        LOG.debug("Inspect: {}", (Object)inspectBefore);
        Long memory = inspectBefore.getHostConfig().getMemory();
        this.dockerRule.getClient().updateContainerCmd(containerId).withBlkioWeight(Integer.valueOf(300)).withCpuShares(Integer.valueOf(512)).withCpuPeriod(Integer.valueOf(100000)).withCpuQuota(Integer.valueOf(50000)).withCpusetMems("0").exec();
        InspectContainerResponse inspectAfter = this.dockerRule.getClient().inspectContainerCmd(containerId).exec();
        HostConfig afterHostConfig = inspectAfter.getHostConfig();
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuShares(), (Matcher)CoreMatchers.is((Object)512));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuPeriod(), (Matcher)CoreMatchers.is((Object)100000L));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuQuota(), (Matcher)CoreMatchers.is((Object)50000L));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpusetMems(), (Matcher)CoreMatchers.is((Object)"0"));
    }

    @Ignore(value="impossible to serder because model bundled in cmd")
    @Test
    public void serDerDocs1() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(UpdateContainerCmdImpl.class);
        UpdateContainerCmdImpl upd = (UpdateContainerCmdImpl)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/containers/container/update/docs.json", type);
        MatcherAssert.assertThat((Object)upd, (Matcher)IsNull.notNullValue());
    }
}

