/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.cmd.CmdIT;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(BuildImageCmd.class);

    @Test
    public void testWaitContainer() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        LOG.info("Container exit code: {}", (Object)exitCode);
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)exitCode)));
    }

    @Test(expected=NotFoundException.class)
    public void testWaitNonExistingContainer() throws Exception {
        ResultCallback.Adapter<WaitResponse> callback = new ResultCallback.Adapter<WaitResponse>(){

            public void onNext(WaitResponse waitResponse) {
                throw new AssertionError((Object)"expected NotFoundException");
            }
        };
        ((ResultCallback.Adapter)this.dockerRule.getClient().waitContainerCmd("non-existing").exec((ResultCallback)callback)).awaitCompletion();
    }

    @Test
    public void testWaitContainerAbort() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        WaitContainerResultCallback callback = this.dockerRule.getClient().waitContainerCmd(container.getId()).start();
        Thread.sleep(5000L);
        callback.close();
        this.dockerRule.getClient().killContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void testWaitContainerTimeout() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "10"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        WaitContainerResultCallback callback = (WaitContainerResultCallback)this.dockerRule.getClient().waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback());
        try {
            callback.awaitStatusCode(100L, TimeUnit.MILLISECONDS);
            throw new AssertionError((Object)"Should throw exception on timeout.");
        }
        catch (DockerClientException e) {
            LOG.info(e.getMessage());
            return;
        }
    }
}

