/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateConfigResponse;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateConfigCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CreateConfigCmdExecIT.class);

    @Test
    public void testCreateConfig() {
        DockerClient dockerClient = this.startSwarm();
        String configName = RandomStringUtils.random((int)10, (boolean)true, (boolean)false);
        CreateConfigResponse response = dockerClient.createConfigCmd().withName(configName).withData("configuration data".getBytes()).exec();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
        String configId = response.getId();
        MatcherAssert.assertThat((Object)configId, (Matcher)Matchers.notNullValue());
        dockerClient.removeConfigCmd(configId).exec();
    }
}

