/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.EndpointResolutionMode;
import com.github.dockerjava.api.model.EndpointSpec;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.NetworkAttachmentConfig;
import com.github.dockerjava.api.model.PortConfig;
import com.github.dockerjava.api.model.PortConfigProtocol;
import com.github.dockerjava.api.model.Service;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.TmpfsOptions;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.github.dockerjava.junit.PrivateRegistryRule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateServiceCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CreateServiceCmdExecIT.class);
    private static final String SERVICE_NAME = "theservice";
    @ClassRule
    public static PrivateRegistryRule REGISTRY = new PrivateRegistryRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private AuthConfig authConfig;
    private DockerClient dockerClient;

    @Before
    public final void setUpCreateServiceCmdExecIT() throws Exception {
        this.authConfig = REGISTRY.getAuthConfig();
        this.dockerClient = this.startSwarm();
    }

    @Test
    public void testCreateService() throws DockerException {
        this.dockerClient.createServiceCmd(new ServiceSpec().withName(SERVICE_NAME).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest")))).exec();
        List services = (List)this.dockerClient.listServicesCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{SERVICE_NAME})).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        this.dockerClient.removeServiceCmd(SERVICE_NAME).exec();
    }

    @Test
    public void testCreateServiceWithNetworks() {
        String networkId = ((CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("networkname").withDriver("overlay").withIpam(new Network.Ipam().withDriver("default")).exec()).getId();
        ServiceSpec spec = new ServiceSpec().withName(SERVICE_NAME).withTaskTemplate(new TaskSpec().withForceUpdate(Integer.valueOf(0)).withRuntime("container").withContainerSpec(new ContainerSpec().withImage("busybox"))).withNetworks((List)Lists.newArrayList((Object[])new NetworkAttachmentConfig[]{new NetworkAttachmentConfig().withTarget(networkId).withAliases((List)Lists.newArrayList((Object[])new String[]{"alias1", "alias2"}))})).withLabels((Map)ImmutableMap.of((Object)"com.docker.java.usage", (Object)"SwarmServiceIT")).withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(1))).withEndpointSpec(new EndpointSpec().withMode(EndpointResolutionMode.VIP).withPorts((List)Lists.newArrayList((Object[])new PortConfig[]{new PortConfig().withPublishMode(PortConfig.PublishMode.host).withPublishedPort(22).withProtocol(PortConfigProtocol.TCP)})));
        this.dockerClient.createServiceCmd(spec).exec();
        List services = (List)this.dockerClient.listServicesCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{SERVICE_NAME})).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Service)services.get(0)).getSpec(), (Matcher)Matchers.is((Object)spec));
        this.dockerClient.removeServiceCmd(SERVICE_NAME).exec();
    }

    @Test
    public void testCreateServiceWithTmpfs() {
        Mount tmpMount = new Mount().withTmpfsOptions(new TmpfsOptions().withSizeBytes(Long.valueOf(600L))).withTarget("/tmp/foo");
        this.dockerClient.createServiceCmd(new ServiceSpec().withName(SERVICE_NAME).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest").withMounts(Collections.singletonList(tmpMount))))).exec();
        List services = (List)this.dockerClient.listServicesCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{SERVICE_NAME})).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        List mounts = this.dockerClient.inspectServiceCmd(SERVICE_NAME).exec().getSpec().getTaskTemplate().getContainerSpec().getMounts();
        MatcherAssert.assertThat((Object)mounts, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(mounts.get(0), (Matcher)Matchers.is((Object)tmpMount));
        this.dockerClient.removeServiceCmd(SERVICE_NAME).exec();
    }

    @Test
    public void testCreateServiceWithValidAuth() throws DockerException {
        this.dockerClient.createServiceCmd(new ServiceSpec().withName(SERVICE_NAME).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest")))).withAuthConfig(this.authConfig).exec();
        List services = (List)this.dockerClient.listServicesCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{SERVICE_NAME})).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        this.dockerClient.removeServiceCmd(SERVICE_NAME).exec();
    }

    @Test
    @Ignore
    public void testCreateServiceWithInvalidAuth() throws DockerException {
        AuthConfig invalidAuthConfig = new AuthConfig().withUsername("testuser").withPassword("testwrongpassword").withEmail("foo@bar.de").withRegistryAddress(this.authConfig.getRegistryAddress());
        this.exception.expect(ConflictException.class);
        this.dockerClient.createServiceCmd(new ServiceSpec().withName(SERVICE_NAME).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest")))).withAuthConfig(invalidAuthConfig).exec();
    }
}

