/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateConfigResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Config;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectConfigCmdIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(InspectConfigCmdIT.class);

    @Test
    public void inspectConfig() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        String configName = RandomStringUtils.random((int)10, (boolean)true, (boolean)false);
        CreateConfigResponse configResponse = dockerClient.createConfigCmd().withName(configName).withData("configuration data".getBytes()).exec();
        LOG.info("Config created with ID {}", (Object)configResponse.getId());
        Config config = dockerClient.inspectConfigCmd(configResponse.getId()).exec();
        Assert.assertEquals((Object)configResponse.getId(), (Object)config.getId());
        Assert.assertEquals((Object)configName, (Object)config.getSpec().getName());
    }
}

