/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.LocalNodeState;
import com.github.dockerjava.api.model.Swarm;
import com.github.dockerjava.api.model.SwarmJoinTokens;
import com.github.dockerjava.api.model.SwarmSpec;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.google.common.collect.Lists;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinSwarmCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(JoinSwarmCmdExecIT.class);
    private DockerClient docker1;
    private DockerClient docker2;

    @Before
    public void setUp() throws Exception {
        this.docker1 = this.startDockerInDocker();
        this.docker2 = this.startDockerInDocker();
    }

    private SwarmJoinTokens initSwarmOnDocker(DockerClient docker) {
        SwarmSpec swarmSpec = new SwarmSpec();
        docker.initializeSwarmCmd(swarmSpec).exec();
        LOG.info("Initialized swarm docker1: {}", (Object)swarmSpec.toString());
        Swarm swarm = docker.inspectSwarmCmd().exec();
        LOG.info("Inspected swarm on docker1: {}", (Object)swarm.toString());
        return swarm.getJoinTokens();
    }

    @Test
    public void joinSwarmAsWorker() throws Exception {
        SwarmJoinTokens tokens = this.initSwarmOnDocker(this.docker1);
        this.docker2.joinSwarmCmd().withRemoteAddrs((List)Lists.newArrayList((Object[])new String[]{"docker1"})).withJoinToken(tokens.getWorker()).exec();
        LOG.info("docker2 joined docker1's swarm");
        Info info = (Info)this.docker2.infoCmd().exec();
        LOG.info("Inspected docker2: {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)info.getSwarm().getLocalNodeState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)LocalNodeState.ACTIVE)));
    }

    @Test
    public void joinSwarmAsManager() throws DockerException, InterruptedException {
        SwarmJoinTokens tokens = this.initSwarmOnDocker(this.docker1);
        this.docker2.joinSwarmCmd().withRemoteAddrs((List)Lists.newArrayList((Object[])new String[]{"docker1"})).withJoinToken(tokens.getManager()).exec();
        LOG.info("docker2 joined docker1's swarm");
        Info info = (Info)this.docker2.infoCmd().exec();
        LOG.info("Inspected docker2: {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)info.getSwarm().getLocalNodeState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)LocalNodeState.ACTIVE)));
    }

    @Test(expected=DockerException.class)
    public void joinSwarmIfAlreadyInSwarm() throws Exception {
        SwarmJoinTokens tokens = this.initSwarmOnDocker(this.docker1);
        this.initSwarmOnDocker(this.docker2);
        this.docker2.joinSwarmCmd().withRemoteAddrs((List)Lists.newArrayList((Object[])new String[]{"docker1"})).withJoinToken(tokens.getWorker()).exec();
    }
}

