/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.LocalNodeState;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaveSwarmCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(LeaveSwarmCmdExecIT.class);

    @Test
    public void leaveSwarmAsMaster() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        Info info = (Info)dockerClient.infoCmd().exec();
        LOG.info("Inspected docker: {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)info.getSwarm().getLocalNodeState(), (Matcher)Matchers.is((Object)LocalNodeState.ACTIVE));
        dockerClient.leaveSwarmCmd().withForceEnabled(Boolean.valueOf(true)).exec();
        LOG.info("Left swarm");
        info = (Info)dockerClient.infoCmd().exec();
        LOG.info("Inspected docker: {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)info.getSwarm().getLocalNodeState(), (Matcher)Matchers.is((Object)LocalNodeState.INACTIVE));
    }

    @Test(expected=DockerException.class)
    public void leavingSwarmThrowsWhenNotInSwarm() throws Exception {
        DockerClient dockerClient = this.startDockerInDocker();
        dockerClient.leaveSwarmCmd().exec();
    }
}

