/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateConfigResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListConfigCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(ListConfigCmdExecIT.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesListConfig() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        String configName = RandomStringUtils.random((int)10, (boolean)true, (boolean)false);
        CreateConfigResponse response = dockerClient.createConfigCmd().withName(configName).withData("configuration data".getBytes()).exec();
        String configId = response.getId();
        try {
            LOG.info("Config created with ID {}", (Object)configId);
            List configs = (List)dockerClient.listConfigsCmd().withFilters(Collections.singletonMap("name", Arrays.asList(configName))).exec();
            MatcherAssert.assertThat((Object)configs, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            dockerClient.removeConfigCmd(configId).exec();
            LOG.info("Config removed with ID {}", (Object)configId);
        }
        List configsAfterRemoved = (List)dockerClient.listConfigsCmd().withFilters(Collections.singletonMap("name", Arrays.asList(configName))).exec();
        MatcherAssert.assertThat((Object)configsAfterRemoved, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }
}

