/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateSecretResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Secret;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSecretCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(ListSecretCmdExecIT.class);

    @Test
    public void tesListSecret() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        int length = 10;
        boolean useLetters = true;
        boolean useNumbers = false;
        String secretName = RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
        CreateSecretResponse exec = dockerClient.createSecretCmd(new SecretSpec().withName(secretName).withData("mon secret en clair")).exec();
        MatcherAssert.assertThat((Object)exec, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)exec.getId(), (Matcher)Matchers.notNullValue());
        LOG.info("Secret created with ID {}", (Object)exec.getId());
        List secrets = (List)dockerClient.listSecretsCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{secretName})).exec();
        MatcherAssert.assertThat((Object)secrets, (Matcher)IsCollectionWithSize.hasSize((int)1));
        dockerClient.removeSecretCmd(((Secret)secrets.get(0)).getId()).exec();
        LOG.info("Secret removed with ID {}", (Object)exec.getId());
        List secretsAfterRemoved = (List)dockerClient.listSecretsCmd().withNameFilter((List)Lists.newArrayList((Object[])new String[]{secretName})).exec();
        MatcherAssert.assertThat((Object)secretsAfterRemoved, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }
}

