/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateServiceResponse;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.cmd.swarm.CreateServiceCmdExecIT;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListServicesCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CreateServiceCmdExecIT.class);
    private static final String SERVICE_NAME = "inspect_service";
    private static final String LABEL_KEY = "com.github.dockerjava.usage";
    private static final String LABEL_VALUE = "test";

    @Test
    public void testListServices() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        Map<String, String> serviceLabels = Collections.singletonMap(LABEL_KEY, LABEL_VALUE);
        CreateServiceResponse response = dockerClient.createServiceCmd(new ServiceSpec().withLabels(serviceLabels).withName(SERVICE_NAME).withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(1))).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest")))).exec();
        String serviceId = response.getId();
        List services = (List)dockerClient.listServicesCmd().withIdFilter(Collections.singletonList(serviceId)).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        services = (List)dockerClient.listServicesCmd().withNameFilter(Collections.singletonList(SERVICE_NAME)).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        services = (List)dockerClient.listServicesCmd().withLabelFilter(serviceLabels).exec();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasSize((int)1));
        dockerClient.removeServiceCmd(SERVICE_NAME).exec();
    }
}

