/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.SwarmNode;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ListSwarmNodesCmdExecIT
extends SwarmCmdIT {
    @Test
    public void testListSwarmNodes() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testListSwarmNodesWithIdFilter() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
        String nodeId = ((SwarmNode)nodes.get(0)).getId();
        List nodesWithId = (List)dockerClient.listSwarmNodesCmd().withIdFilter(Collections.singletonList(nodeId)).exec();
        MatcherAssert.assertThat((Object)nodesWithId.size(), (Matcher)Matchers.is((Object)1));
        List nodesWithNonexistentId = (List)dockerClient.listSwarmNodesCmd().withIdFilter(Collections.singletonList("__nonexistent__")).exec();
        MatcherAssert.assertThat((Object)nodesWithNonexistentId.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testListSwarmNodesWithNameFilter() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
        String nodeName = ((SwarmNode)nodes.get(0)).getSpec().getName();
        List nodesWithFirstNodesName = (List)dockerClient.listSwarmNodesCmd().withNameFilter(Collections.singletonList(nodeName)).exec();
        MatcherAssert.assertThat((Object)nodesWithFirstNodesName.size(), (Matcher)Matchers.is((Object)1));
        List nodesWithNonexistentName = (List)dockerClient.listSwarmNodesCmd().withNameFilter(Collections.singletonList("__nonexistent__")).exec();
        MatcherAssert.assertThat((Object)nodesWithNonexistentName.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testListSwarmNodesWithMembershipFilter() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodesWithAcceptedMembership = (List)dockerClient.listSwarmNodesCmd().withMembershipFilter(Collections.singletonList("accepted")).exec();
        MatcherAssert.assertThat((Object)nodesWithAcceptedMembership.size(), (Matcher)Matchers.is((Object)1));
        List nodesWithPendingMembership = (List)dockerClient.listSwarmNodesCmd().withMembershipFilter(Collections.singletonList("pending")).exec();
        MatcherAssert.assertThat((Object)nodesWithPendingMembership.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testListSwarmNodesWithRoleFilter() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodesWithManagerRole = (List)dockerClient.listSwarmNodesCmd().withRoleFilter(Collections.singletonList("manager")).exec();
        MatcherAssert.assertThat((Object)nodesWithManagerRole.size(), (Matcher)Matchers.is((Object)1));
        List nodesWithWorkerRole = (List)dockerClient.listSwarmNodesCmd().withRoleFilter(Collections.singletonList("worker")).exec();
        MatcherAssert.assertThat((Object)nodesWithWorkerRole.size(), (Matcher)Matchers.is((Object)0));
    }
}

