/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateServiceResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.cmd.swarm.CreateServiceCmdExecIT;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTasksCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CreateServiceCmdExecIT.class);
    private static final String SERVICE_NAME = "inspect_task";
    private static final String TASK_LABEL_KEY = "com.github.dockerjava.usage";
    private static final String TASK_LABEL_VALUE = "test";

    @Test
    public void testListTasks() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        Map<String, String> taskLabels = Collections.singletonMap(TASK_LABEL_KEY, TASK_LABEL_VALUE);
        CreateServiceResponse response = dockerClient.createServiceCmd(new ServiceSpec().withName(SERVICE_NAME).withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(2))).withTaskTemplate(new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox:latest"))).withLabels(taskLabels)).exec();
        String serviceId = response.getId();
        List tasks = (List)Awaitility.await().until(() -> dockerClient.listTasksCmd().withServiceFilter(new String[]{serviceId}).exec(), Matchers.hasSize((int)2));
        String taskId = ((Task)tasks.get(0)).getId();
        String secondTaskId = ((Task)tasks.get(1)).getId();
        tasks = dockerClient.listTasksCmd().withIdFilter(new String[]{taskId}).exec();
        MatcherAssert.assertThat((Object)tasks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Task)tasks.get(0)).getId(), (Matcher)Matchers.is((Object)taskId));
        tasks = dockerClient.listTasksCmd().withIdFilter(new String[]{secondTaskId, taskId}).exec();
        MatcherAssert.assertThat((Object)tasks, (Matcher)Matchers.hasSize((int)2));
        String nodeId = (String)Awaitility.await().until(() -> ((Task)dockerClient.listTasksCmd().withIdFilter(new String[]{secondTaskId}).exec().get(0)).getNodeId(), Objects::nonNull);
        tasks = dockerClient.listTasksCmd().withNodeFilter(new String[]{nodeId}).exec();
        MatcherAssert.assertThat((Object)((Task)tasks.get(0)).getNodeId(), (Matcher)Matchers.is((Object)nodeId));
        tasks = dockerClient.listTasksCmd().withStateFilter(new TaskState[]{TaskState.RUNNING}).exec();
        MatcherAssert.assertThat((Object)tasks, (Matcher)Matchers.hasSize((int)2));
        tasks = dockerClient.listTasksCmd().withLabelFilter(taskLabels).exec();
        MatcherAssert.assertThat((Object)tasks, (Matcher)Matchers.hasSize((int)2));
        tasks = dockerClient.listTasksCmd().withLabelFilter(new String[]{"com.github.dockerjava.usage=test"}).exec();
        MatcherAssert.assertThat((Object)tasks, (Matcher)Matchers.hasSize((int)2));
    }
}

