/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogSwarmObjectCmd;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceRestartCondition;
import com.github.dockerjava.api.model.ServiceRestartPolicy;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.github.dockerjava.utils.LogContainerTestCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;

public class LogSwarmObjectIT
extends SwarmCmdIT {
    @Test
    public void testLogsCmd() throws InterruptedException, IOException {
        DockerClient dockerClient = this.startSwarm();
        String snippet = "hello world";
        TaskSpec taskSpec = new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox").withCommand(Arrays.asList("echo", snippet))).withRestartPolicy(new ServiceRestartPolicy().withCondition(ServiceRestartCondition.NONE));
        ServiceSpec serviceSpec = new ServiceSpec().withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(1))).withTaskTemplate(taskSpec).withName("log-worker");
        String serviceId = dockerClient.createServiceCmd(serviceSpec).exec().getId();
        int since = (int)System.currentTimeMillis() / 1000;
        List tasks = new ArrayList();
        for (int i = 0; i < 10 && (tasks = dockerClient.listTasksCmd().withServiceFilter(new String[]{serviceId}).withStateFilter(new TaskState[]{TaskState.SHUTDOWN}).exec()).size() != 1; ++i) {
            TimeUnit.SECONDS.sleep(3L);
        }
        MatcherAssert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)1));
        String taskId = ((Task)tasks.get(0)).getId();
        this.validateLog(dockerClient.logServiceCmd(serviceId).withStdout(Boolean.valueOf(true)), snippet);
        this.validateLog(dockerClient.logTaskCmd(taskId).withStdout(Boolean.valueOf(true)), snippet);
        this.validateLog(dockerClient.logServiceCmd(serviceId).withStdout(Boolean.valueOf(true)).withSince(Integer.valueOf(since)), snippet);
        this.validateLog(dockerClient.logTaskCmd(taskId).withStdout(Boolean.valueOf(true)).withSince(Integer.valueOf(since)), snippet);
        dockerClient.removeServiceCmd(serviceId).exec();
    }

    private void validateLog(LogSwarmObjectCmd logCmd, String messsage) throws InterruptedException, IOException {
        try (LogContainerTestCallback loggingCallback = (LogContainerTestCallback)logCmd.exec((ResultCallback)new LogContainerTestCallback(true));){
            loggingCallback.awaitCompletion(5L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)loggingCallback.toString(), (Matcher)Matchers.containsString((String)messsage));
        }
    }
}

