/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Swarm;
import com.github.dockerjava.api.model.SwarmNode;
import com.github.dockerjava.api.model.SwarmNodeRole;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveSwarmNodeCmdExecIT
extends SwarmCmdIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveSwarmNodeCmdExecIT.class);

    @Test
    public void testRemoveSwarmNode() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        Swarm swarm = dockerClient.inspectSwarmCmd().exec();
        DockerClient docker2 = this.startDockerInDocker();
        docker2.joinSwarmCmd().withRemoteAddrs((List)Lists.newArrayList((Object[])new String[]{"docker1"})).withJoinToken(swarm.getJoinTokens().getWorker()).exec();
        LOGGER.info("docker2 joined docker's swarm");
        List nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)2, (Matcher)Matchers.is((Object)nodes.size()));
        Optional<SwarmNode> firstWorkNode = nodes.stream().filter(node -> node.getSpec().getRole() == SwarmNodeRole.WORKER).findFirst();
        dockerClient.removeSwarmNodeCmd(firstWorkNode.get().getId()).withForce(Boolean.valueOf(true)).exec();
        nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
    }
}

