/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.SwarmSpec;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.DockerMatchers;
import com.github.dockerjava.junit.category.Integration;
import com.github.dockerjava.junit.category.SwarmModeIntegration;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={SwarmModeIntegration.class, Integration.class})
public abstract class SwarmCmdIT
extends CmdIT {
    private static final String DOCKER_IN_DOCKER_IMAGE_REPOSITORY = "docker";
    private static final String DOCKER_IN_DOCKER_IMAGE_TAG = "17.12-dind";
    private static final String DOCKER_IN_DOCKER_CONTAINER_PREFIX = "docker";
    private static final String NETWORK_NAME = "dind-network";
    private final AtomicInteger numberOfDockersInDocker = new AtomicInteger();
    private final Set<String> startedContainerIds = new HashSet<String>();

    @Before
    public final void setUpMultiNodeSwarmCmdIT() throws Exception {
        Assume.assumeThat((Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_24));
    }

    protected DockerClient startSwarm() {
        DockerClient dockerClient;
        try {
            dockerClient = this.startDockerInDocker();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        dockerClient.initializeSwarmCmd(new SwarmSpec()).exec();
        return dockerClient;
    }

    @After
    public final void tearDownMultiNodeSwarmCmdIT() {
        for (String containerId : this.startedContainerIds) {
            try {
                this.dockerRule.getClient().removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
            }
            catch (NotFoundException notFoundException) {}
        }
        try {
            this.dockerRule.getClient().removeNetworkCmd(NETWORK_NAME).exec();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected DockerClient startDockerInDocker() throws InterruptedException {
        DockerClient hostDockerClient = this.dockerRule.getClient();
        try {
            hostDockerClient.inspectNetworkCmd().withNetworkId(NETWORK_NAME).exec();
        }
        catch (NotFoundException e) {
            try {
                hostDockerClient.createNetworkCmd().withName(NETWORK_NAME).exec();
            }
            catch (ConflictException conflictException) {
                // empty catch block
            }
        }
        try (ResultCallback.Adapter callback = hostDockerClient.pullImageCmd("docker").withTag(DOCKER_IN_DOCKER_IMAGE_TAG).start();){
            callback.awaitCompletion();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExposedPort exposedPort = ExposedPort.tcp((int)2375);
        CreateContainerResponse response = hostDockerClient.createContainerCmd("docker:17.12-dind").withHostConfig(HostConfig.newHostConfig().withNetworkMode(NETWORK_NAME).withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindIp((String)"127.0.0.1"), exposedPort)}).withPrivileged(Boolean.valueOf(true))).withAliases(new String[]{"docker" + this.numberOfDockersInDocker.incrementAndGet()}).exec();
        String containerId = response.getId();
        this.startedContainerIds.add(containerId);
        hostDockerClient.startContainerCmd(containerId).exec();
        InspectContainerResponse inspectContainerResponse = hostDockerClient.inspectContainerCmd(containerId).exec();
        Ports.Binding binding = ((Ports.Binding[])inspectContainerResponse.getNetworkSettings().getPorts().getBindings().get(exposedPort))[0];
        DockerClient dockerClient = this.initializeDockerClient(binding);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> dockerClient.pingCmd().exec());
        return dockerClient;
    }

    private DockerClient initializeDockerClient(Ports.Binding binding) {
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withRegistryUrl("https://index.docker.io/v1/").withDockerHost("tcp://" + binding).build();
        return SwarmCmdIT.createDockerClient((DockerClientConfig)config);
    }
}

