/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Swarm;
import com.github.dockerjava.api.model.SwarmCAConfig;
import com.github.dockerjava.api.model.SwarmDispatcherConfig;
import com.github.dockerjava.api.model.SwarmOrchestration;
import com.github.dockerjava.api.model.SwarmRaftConfig;
import com.github.dockerjava.api.model.SwarmSpec;
import com.github.dockerjava.api.model.TaskDefaults;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSwarmCmdExecIT
extends SwarmCmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(UpdateSwarmCmdExecIT.class);

    @Test
    public void updateSwarm() throws DockerException {
        DockerClient dockerClient = this.startSwarm();
        SwarmSpec newSpec = new SwarmSpec().withName("default").withDispatcher(new SwarmDispatcherConfig().withHeartbeatPeriod(Long.valueOf(10000000L))).withOrchestration(new SwarmOrchestration().withTaskHistoryRententionLimit(100)).withCaConfig(new SwarmCAConfig().withNodeCertExpiry(Long.valueOf(3600000000000L))).withRaft(new SwarmRaftConfig().withElectionTick(8).withSnapshotInterval(20000L).withHeartbeatTick(5).withLogEntriesForSlowFollowers(200L)).withTaskDefaults(new TaskDefaults());
        Swarm swarm = dockerClient.inspectSwarmCmd().exec();
        LOG.info("Inspected swarm: {}", (Object)swarm.toString());
        MatcherAssert.assertThat((Object)swarm.getSpec(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)newSpec))));
        dockerClient.updateSwarmCmd(newSpec).withVersion(swarm.getVersion().getIndex()).exec();
        LOG.info("Updated swarm: {}", (Object)newSpec.toString());
        swarm = dockerClient.inspectSwarmCmd().exec();
        LOG.info("Inspected swarm: {}", (Object)swarm.toString());
        MatcherAssert.assertThat((Object)swarm.getSpec(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newSpec)));
    }

    @Test(expected=DockerException.class)
    public void updatingSwarmThrowsWhenNotInSwarm() throws Exception {
        DockerClient dockerClient = this.startDockerInDocker();
        dockerClient.updateSwarmCmd(new SwarmSpec()).withVersion(Long.valueOf(1L)).exec();
    }
}

