/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.SwarmNode;
import com.github.dockerjava.api.model.SwarmNodeAvailability;
import com.github.dockerjava.api.model.SwarmNodeSpec;
import com.github.dockerjava.api.model.SwarmNodeState;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class UpdateSwarmNodeIT
extends SwarmCmdIT {
    @Test
    public void testUpdateSwarmNode() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        List nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)1, (Matcher)Matchers.is((Object)nodes.size()));
        SwarmNode node = (SwarmNode)nodes.get(0);
        MatcherAssert.assertThat((Object)SwarmNodeState.READY, (Matcher)Matchers.is((Object)node.getStatus().getState()));
        SwarmNodeSpec nodeSpec = node.getSpec().withAvailability(SwarmNodeAvailability.PAUSE);
        dockerClient.updateSwarmNodeCmd().withSwarmNodeId(node.getId()).withVersion(node.getVersion().getIndex()).withSwarmNodeSpec(nodeSpec).exec();
        nodes = (List)dockerClient.listSwarmNodesCmd().exec();
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((SwarmNode)nodes.get(0)).getSpec().getAvailability(), (Matcher)Matchers.is((Object)SwarmNodeAvailability.PAUSE));
    }
}

